/*------------------------------------------------------------------------------*
 * File Name: QueryBldrDlg.h	   												*
 * Creation: AW 11/21/2005														*
 * Purpose: Used for ADO programming for Origin DB 								*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	AW 12/12/05 USING_UNTITLED_NAME												*
 *	Jasmine 04/11/06 v8.0388 ADD_MRDSFLIST										*
 *	Jasmine 04/11/06 v8.0388 GET_QUERY_IN_ACTIVE_WKS							*
 *	CPY 4/18/06 MINIZE_BOX_AND_OTHER_CLEANUP									*
 *	Jasmine 04/19/06 v8.0394 SHOW_FILE_NAME_WITHOUT_PATH						*
 *	CPY 5/8/06 IMPORT_TO_LINKED_WKS_IF_PRESENT									*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Jasmine 09/19/07 QA80-10385 LOCALIZATION_FOR_NEUTRAL_DIALOG					*
 *	AW 11/02/07 QUERYBUILD_LOCALIZATION											*
 *	CPY 11/3/2007 LANGUAGE_CHAR_FROM_OC											*
 *	CPY 11/4/2007 ADD_L_AND_LC_FOR_MANY_STRS_WITHOUT_COMMENTS					*
 *	Fisher 11/15/07 ADD_MAP_ID_TO_CHM											*
 *	EJP 2007-12-07 v8.0765 FIX_QUERY_BUILDER_MENU_WHEN_CHANGE_ORIGIN_LANG		*
 *	AW 01/21/08 AUTO_DETECT_SQL_SYNTAX_TYPE										*
 *	CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL					*
 *	CPY 1/25/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL_BUT_ALLOW_SWITCH_WKS
 *	AW 02/04/08 MORE_ON_LOGIN_PROMPT											*
 *	AW 11/02/07 MORE_ON_QUERYBUILD_LOCALIZATION									*
 *	Jasmine 06/12/08 QA80-10852 SYMOBLE_CELSIUS_DEGREE_FAIL_TO_SHOW_IN_PREVIEW	*
 *	AW 06/18/08 QA80-11727 HIDE_PW_IN_ADO										*
 *	EJP 2008-09-19 v8.0944 QA80-11727 HIDE_PW_IN_QUERYBUILDER_DLG				*
 *	Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE										*
 *	EJP 2009-03-27 QA80-11727 MORE_HIDE_PW_IN_QUERYBUILDER_DLG					*
 *	Folger 05/11/09 QA80-13571 CHECK_ADD_FILE_EXT_SHOULD_RETURN_PROPER_ERROR	*
 *	CPY 5/16/09 DB_IMPORT_PREVIEW_SHOULD_NOT_CREATE_NOTES						*
 *	Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER		*
 *	Sophy 9/18/2009 RESET_CURRENT_LANGUAGE_OF_LOCALIZER_IN_QUERY_BUILDER_CAUSE_EXCEPTION
 *	Sophy 12/25/2009 QA80-14057-P2 FAIL_TO_SELECT_DATA_FROM_TABLE_NOT_IN_DEFAULT_DATABASE
 *	Sophy 12/31/2009 MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER					*
 *	Sophy 3/3/2010 QA81-14057-P5 LOAD_RECENT_ODS_FILE_SHOULD_NOT_NEED_TO_EDIT_CONNSTR
 *------------------------------------------------------------------------------*/
#ifndef _ORIGIN_ADO_H
#define _ORIGIN_ADO_H

#include <ocu.h>

//#define ON_ACTIVEX_EVENT(_evt, _idCntrl, _ocFunc, _argList)				msgMap.AddEventMsg(_evt, _idCntrl, _ocFunc, _argList);

#define ON_BUILDER_SQL_CHANGED(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(212, _idCntl, _ocFunc, VTS_CTRL VTS_NONE )

#define ID_DS_FLIST_SEPARATOR      		41000	///Jasmine 04/10/06 ADD_MRDSFLIST
#define ID_DS_FLIST_BEGIN	      		40070	///Jasmine 04/10/06 ADD_MRDSFLIST

/// END PREVIEW_WKS_IN_ADO

/// AW 11/02/07 QUERYBUILD_LOCALIZATION
enum {
	QB_LANG_E = 0,
	QB_LANG_G = 1,
	QB_LANG_J = 8,
	QB_LANG_C = 5,
};
/// END  QUERYBUILD_LOCALIZATION

#define STR_INI_SECTION_ADO_RECENT_FILE "ADORecentFileList"
#define STR_INI_SECTION_ADO_DS_RECENT_FILE "ADODataSourceRecentFileList"	///Jasmine 04/10/06 ADD_MRDSFLIST

#define BASE_WINDOW MultiPaneDlg

#define _DB_MSG(_STR) //out_str(_STR)
	
//#include "TreeEditEvents.h"

/// END PREVIEW_WKS_IN_ADO

/*
#define STR_QUERY_NODE_TAG				"Node"
#define STR_QUERY_NODE_NAME				"Name"
#define STR_QUERY_NODE_SQL				"SQL"
#define STR_QUERY_NODE_CONNECTION		"Connection"
#define STR_QUERY_SQL_SUB_NODE_NAME		"SQL"
#define STR_QUERY_CONN_SUB_NODE_NAME	"Connection"
*/
#define ERR_CODE_FAIL_READ_SECTION		-1 
#define ERR_CODE_FAIL_OPEN_FILE			-2
#define ERR_CODE_FAIL_SAVE_FILE			-3


/// AW 01/21/08 AUTO_DETECT_SQL_SYNTAX_TYPE
// I got this from their forum
enum {
 	xsSQL92 = 0,
 	xsMSSQL7 = 10,
	xsMSSQL2000 = 11,
	xsMSSQL2005 = 12,
	xsJet3 = 70,	// (for MS Access 97 and lower)
	xsJet4 = 71, 	// (for MS Access 2000 and higher)
	xsAuto = 2		// (the component will try to detect SQL server automatically; not recommended to use if you already know your database server)
					// Please note: their tech support replied: Autodetection works fine for most of supported servers, but not for all of them.
};
/// END AUTO_DETECT_SQL_SYNTAX_TYPE


#define STR_WARNING						_L("Warning")
#define STR_MSG							_L("Message")
#define STR_MSG_CREATE_NEW_QUERY		_L("Get data source from existing file or click CANCEL to create a new one in the next dialog")
#define STR_MSG_SAVE_CHANGED_IN_FILE	_L("Contents in %s has changed, do you want to save the changes?")
#define STR_QUESTION_USE_CUR_DS			_L("Current data source string is not empty, do use want to use it?")
#define STR_QUESTION_NEED_DS			_L("No data source defined, please go to the Query > Data Source menu to make one first")
#define STR_QUESTION_NEED_QUERY			_L("No valid query defined, can not save")



#define STR_QUERY_CONN_FILE_NAME		_L("Data Source File Name")
#define STR_QUERY_SQL_DEFAULT			"Select\r\nFrom"
#define STR_DEFAULT_SQL_PROVIDE			"Provider=SQLOLEDB.1"  /// AW 04/27/06 SET_DEFAULT_PROVIDER

#define STR_SECTION_FORMAT				"[%s]\r\n"
#define STR_NO_NAME_TITLE				"Untitled"			/// AW 12/12/05 USING_UNTITLED_NAME
#define STR_DS_FILE_DIALOG				"[Data Source File (*.ODS)] *.ODS"
#define STR_QUERY_FILE_DIALOG			"[Query File (*.ODQ)] *.ODQ"
#define STR_QUERY_DLG_NAME				_L("Query Builder")	


#define STR_ERR							_L("Error")
#define STR_ERR_INIT_QUERY				_L("Can not initialize Query Builder control!")
#define STR_ERR_UPDATE_QUERY			_L("Wrong query string, can not update Query Builder!")
#define STR_ERR_QUERY_BUILD				_L("Fail to build query!")
#define STR_ERR_INVALID_CONNECT_STR		_L("Invalid connection string!")
#define STR_ERR_FAIL_OPEN_FILE			_L("Fail to open %s!")
#define STR_ERR_FAIL_SAVE_FILE			_L("Fail to save %s!")
#define STR_ERR_FAIL_READ_SECTION		_L("Fail to read section %s in %s!")
#define STR_ERR_FAIL_SET_OPTIONS		_L("Fail to set Query Builder options!")


#define STR_NO_DS	"None"
#define STR_HIDE_SQL	_L("Hide SQL")
#define STR_SHOW_SQL	_L("Show SQL")
#define STR_PASSWORD	"Password="		/// AW 06/18/08 QA80-11727 HIDE_PW_IN_ADO
#define STR_PWD			"PWD=" /// EJP 2009-03-27 QA80-11727 MORE_HIDE_PW_IN_QUERYBUILDER_DLG

#define SAVED_SQL_FILE_NAME				"SQLQuery.xml"
#define INPUT_NEW_DATA_SOURCE_NAME		_L("Save current data source as")
#define INPUT_NEW_QUERY_NAME			_L("Save current query string as")

#define WM_USER_SQL_TEXT_CHANGE			(WM_USER + 1000)
#define WM_USER_SQL_BOX_CLOSE			(WM_USER + 998)
#define WM_USER_SQL_CLEAR_CHANGE		(WM_USER + 1001)

enum {
	CHECK_QUERY = 1,
	CHECK_DS	= 2,
	CHECK_BOTH	= 3
};

///Sophy 12/31/2009 MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER
#define	STR_ODBC_SRC	"DSN="
static BOOL	_is_datasource_allow_odbc_option(LPCSTR lpcszConn)
{
	string strConnStr(lpcszConn);
	if ( strConnStr.Find(STR_ODBC_SRC) >= 0 )
		return TRUE;
	return FALSE;
}
///end MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER
class QueryEditDlg : public ResizeDialog
{
private:
	string 	m_strSQL;
	Edit	m_edSQL;
	
public:
	QueryEditDlg(LPCSTR lpcszSQL = NULL) : ResizeDialog(IDD_MULTI_EDIT_BOX, "ODlg8")
	{
		m_strSQL = lpcszSQL;
	}
	int Create(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = ResizeDialog::Create(hParent);
		
		return nRet;
	}
	void UpdateQueryText(LPCSTR lpcszSQL = NULL)
	{
		m_strSQL = lpcszSQL;
		m_edSQL.Text = m_strSQL;
		m_bModified = false;
	}
	string GetQueryText()
	{
		return m_strSQL;
	}
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_SIZE(OnDlgResize)
		ON_DESTROY(OnDestroy)
		ON_EN_CHANGE(IDC_EDIT_BOX, OnSQLTextChanged)	
		ON_BN_CLICKED(IDC_APPLY_BTN, OnApply)
		ON_SYSCOMMAND(OnSystemCommand)//---- CPY 4/18/06 MINIZE_BOX_AND_OTHER_CLEANUP
		ON_HELPINFO(OnHelp)
	EVENTS_END
	
	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_ADO_DLG;
		return true;
	}
	BOOL OnInitDialog() 
	{
		ResizeDialog::OnInitDialog();
		m_edSQL = GetItem(IDC_EDIT_BOX);
		m_edSQL.Text = m_strSQL;
		m_bModified = false;
		//hide OK and Cancel button
		Button btnOK = GetItem(IDOK);
		Button btnCancel = GetItem(IDCANCEL);
		btnOK.Visible = btnCancel.Visible = false;
		
		RECT rBtn, rBox;
		GetClientRect(btnOK, rBtn);
		GetClientRect(m_edSQL, rBox);
		StretchControlHeight(IDC_EDIT_BOX, rBox.left, rBox.top, rBtn.bottom);
		//Text = "Query String"; //CPY 4/18/06 MINIZE_BOX_AND_OTHER_CLEANUP
		updateTitle();
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nBottomIDs[]  = {IDC_APPLY_BTN, 0};
		ResizeMoveControlsRightBottom(IDC_EDIT_BOX, NULL, nBottomIDs, cx, cy);

		return true;
	}
	BOOL OnDestroy();
	BOOL OnApply(Control cntrl)
	{
		string strNew = m_edSQL.Text;
//		if( !strNew.CompareNoCase(m_strSQL) )
//			return true;
		m_strSQL = strNew;
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_SQL_TEXT_CHANGE);
		
		m_bModified = false;
		updateTitle();
		return true;
	}
	BOOL OnSQLTextChanged(Control cntrl)
	{
		/*
		string strNew = m_edSQL.Text;
		if( !strNew.CompareNoCase(m_strSQL) )
			return FALSE;
		m_strSQL = strNew;
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_SQL_TEXT_CHANGE);
		*/
		m_bModified = true;
		updateTitle();
		return TRUE;
	}
private:
	void updateTitle()
	{
		string strTitle = "Query String";
		if(m_bModified)
			strTitle += "*";
		
		Text = strTitle;
	}
	bool m_bModified;
};




class ADOBuildQueryDlg : public MultiPaneDlg
{
private:
	Object 			m_ActiveQueryBuilderX;
	Control			m_btnPreview, m_btnShowSQL, m_btnImport;
	Edit			m_editConnStr;
	
	Worksheet	m_wksActive;//---- CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
	
	//------ Preview Wks Related
	WorksheetControl m_wc;
	WorksheetPage	m_wpg;
	Worksheet		m_wks;
	bool			m_bTempWksCreated;
	int				m_nPreviewLines;
	//------
	
	BOOL 			m_bSQLModified, m_bDSModified, m_bValid, m_bReady, m_bInited;
	BOOL			m_bLockQuery;
	BOOL 			m_bLoginPrompt;		/// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
	///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
	BOOL			m_bUseODBC;	
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	MRFList 		m_MRFList;
	/// END ADD_RECENT_FILE_LIST_CLASS
	MRFList 		m_MRDSFList;	///Jasmine 04/10/06 ADD_MRDSFLIST, most recent Date Source File List	

protected:
	string			m_strConnection, m_strSQL, m_strFileName, m_strDSFileName;
	string 			m_strDefaultProvider; 	/// AW 04/27/06 SET_DEFAULT_PROVIDER
private:
	init()
	{
		m_strFileName = STR_NO_NAME_TITLE + STR_QUERY_FILE_EXT;
		m_strDSFileName = STR_NO_DS;	//"";	///Jasmine 04/08/06 show both ods and odq file name in title
		m_strSQL = "";
		m_strConnection = "";
		m_bValid = FALSE;
		m_bReady = FALSE;
		m_bSQLModified = false;
		m_bDSModified = false;
		m_bInited = FALSE;
		m_bLockQuery = FALSE;
		m_nPreviewLines = 50;
		m_strDefaultProvider = STR_DEFAULT_SQL_PROVIDE; 	/// AW 04/27/06 SET_DEFAULT_PROVIDER
		m_bLoginPrompt = FALSE;
		///Sophy 8/3/2009 QA80-14057 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		m_bUseODBC = FALSE;
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
//		m_bTempWksCreated = false;
	}

	bool getPreviewWks()  
	{
		if(m_wc) 
		{
			m_wks.SetSize(-1, 0);    /// AW 03/09/06 Need clean wks first, but worksheetcontrol provide method to do it.
			return true;
		}
		
		if(!m_bTempWksCreated)
		{
			if(m_wks)
			{
				_DB_MSG("err, m_wks already created");
				return false;
			}
			m_wpg.Create(NULL,CREATE_HIDDEN);

			if(m_wpg)
			{
				m_wks = m_wpg.Layers();
				if(m_wks)
				{
					Control ctrlTmp =		GetItem(IDC_ADO_WKS_PREVIEW);
					HWND hWnd = ctrlTmp.GetSafeHwnd();
					if(hWnd)
						m_wc.CreateControl(hWnd);
					else
						return false;
					
					m_wc.Attach(m_wpg.GetName());
					m_wc.SetHeadingType(WDC_HEADING_LN);
					m_wc.SetFont(SYSTEM_FIXED_FONT);		///Jasmine 06/12/08 QA80-10852 SYMOBLE_CELSIUS_DEGREE_FAIL_TO_SHOW_IN_PREVIEW
					m_bTempWksCreated = true;
				}
			}
		}
		return m_bTempWksCreated;
	}
	/*
	void repositionControl(int cx, int cy)
	{
		RECT rr,rr2;
		int nEdge = GetControlGap();
		if(IsTopPaneShown())
		{
			GetClientRect(m_SQL, rr);
			rr.right = cx - nEdge;
			MoveControl(m_SQL, rr);
		}
		string strTemp;
		strTemp.Format(" repositionControl  rr left=%d top=%d right=%d", rr.left, rr.top, rr.right);
		out_str(strTemp);

		Control QueryControl = GetItem(IDC_ACTIVEQUERYBUILDERX1);
		GetClientRect(QueryControl, rr2);
		rr2.top = rr.bottom + nEdge;
		MoveControl(QueryControl, rr2);
		
	}
	*/
	
	bool	updateTopPaneControlShow()
	{
		
		RECT rDlg,rr,rr2;

		int nEdge = GetControlGap();
		m_wndDlg.GetClientRect(&rDlg);
		int cx = RECT_WIDTH(rDlg);
		rr.bottom = 0;
				
		Control QueryControl = GetItem(IDC_ACTIVEQUERYBUILDERX1);
		GetClientRect(QueryControl, rr2);
		rr2.top = rr.bottom + nEdge;
		MoveControl(QueryControl, rr2);
		
		return false;
		
	}
	
	void setSQLString(LPCSTR lpcszSQL, bool bUpdateActiveQuery = true, bool bUpdateSQLBox = true)
	{
		if(bUpdateActiveQuery)
		{
			m_bLockQuery = true;
			/// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
			//BOOL bOldPrompt = m_ActiveQueryBuilderX.LoginPrompt;
			//m_ActiveQueryBuilderX.LoginPrompt = isDSPasswordSaved()? false:true;
			/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
			//m_ActiveQueryBuilderX.LoginPrompt = false;  // disable it only use our password dlg
			/// END MORE_ON_LOGIN_PROMPT
			
			/// END HANDLE_PASSWORD_IN_CONNECTION
			m_ActiveQueryBuilderX.Sql = lpcszSQL;
			// m_ActiveQueryBuilderX.LoginPrompt = bOldPrompt; /// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
			m_bLockQuery = false;
		}
		m_strSQL = lpcszSQL;
		if(bUpdateSQLBox)
			updateSQLBox();
		updateDialogTitle();
	}
	
	bool setConnString(LPCSTR lpcszConn, bool bOpenDataLink = false)
	{
		m_bLockQuery = true;
		m_ActiveQueryBuilderX.ConnectionString = lpcszConn;
		bool bRet = true;
		if(bOpenDataLink)
			bRet = m_ActiveQueryBuilderX.EditConnectionString();
		
		/// AW 04/27/06 SET_DEFAULT_PROVIDER
		if ( bRet )
		{
			
			/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
			// temp fixing, we don't have live Oracle server in NOHO now, the one I have installed expired
			string strConn = m_ActiveQueryBuilderX.ConnectionString;
			if ( db_need_login_prompt(strConn) )
			{
				m_bLoginPrompt = true; 
			}
			else
			{	
				m_bLoginPrompt = false;
			}
			m_ActiveQueryBuilderX.LoginPrompt = m_bLoginPrompt;	
			/// END MORE_ON_LOGIN_PROMPT
			
			m_ActiveQueryBuilderX.Connect();
			m_ActiveQueryBuilderX.RefreshMetadata();
			/// AW 01/21/08 AUTO_DETECT_SQL_SYNTAX_TYPE
			m_ActiveQueryBuilderX.SQLSyntax = xsAuto;   
			//int nUsedSQLSyntax = m_ActiveQueryBuilderX.UsedSQLSyntax;    // fo testing checking, Their tech support told me I can use this property, but looks there is a bug here so I comments it.
			/// END AUTO_DETECT_SQL_SYNTAX_TYPE

			
			strConn = m_ActiveQueryBuilderX.ConnectionString;
			vector<string> vsKeys, vsValues, vsKeysLower;
			int nRet = ocu_separate_key_values(strConn, &vsKeys, &vsValues);
			vsKeysLower = vsKeys;
			for(int ii = 0; ii < vsKeys.GetSize(); ii++) 
				vsKeysLower[ii].MakeLower();
			int nn = vsKeysLower.Find("provider"); 
			if(nn >= 0) 
			{
				m_strDefaultProvider = vsKeys[nn] + "=" + vsValues[nn]; 
			}
		}
		/// END SET_DEFAULT_PROVIDER

		m_bLockQuery = false;
		return bRet;
	}
	///Jasmine 04/11/06 GET_QUERY_IN_ACTIVE_WKS
	bool getActiveWksQuery()
	{
		//---- CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
		//Worksheet wks = Project.ActiveLayer();
		Worksheet wks = getActiveWks();
		//----
		if(!wks)
			return false;
#ifndef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__	///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		if(!db_wks_get_query(wks, m_strConnection, m_strSQL, m_strDSFileName) )
		///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#else
		m_bUseODBC = FALSE; //default FALSE, keep the same as old logic.
		if(!db_wks_get_query(wks, m_strConnection, m_strSQL, m_strDSFileName, &m_bUseODBC) )
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		{
			///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			SetUseODBC(m_bUseODBC);
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__		
			///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
			ASSERT(false);
			return false; 
		}
		setFilenameToWks(wks);
		m_bSQLModified = false;
		m_bDSModified = false;
//		m_bOpenFile = TRUE;
		if(Connect())
		{
			_DB_MSG("After load Wks");
			PostMessage(WM_USER_SQL_CLEAR_CHANGE);
			///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			SetUseODBC(m_bUseODBC);
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__		
			///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		}
		return true;
	}
	///End GET_QUERY_IN_ACTIVE_WKS	 	
	//--------------- CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
private:
	Worksheet getActiveWks()
	{
		if(!m_wksActive)
		{
			out_str("setting to active wks");
			m_wksActive = Project.ActiveLayer();
		}
		
		return m_wksActive;
	}
	void invalidateActiveWks() { Worksheet wksTemp; m_wksActive = wksTemp;}
	//---------------
public:
	//---- CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
	ADOBuildQueryDlg(Worksheet& wks) : MultiPaneDlg(IDD_ADO_QUERY_BUILDER, "ODlg8")
	{
		m_wksActive = wks;
	}
	//----
	
	ADOBuildQueryDlg(LPCSTR lpcszQueryFileName = NULL) : MultiPaneDlg(IDD_ADO_QUERY_BUILDER, "ODlg8")
	{
		if(lpcszQueryFileName)
			m_strFileName = lpcszQueryFileName;
	}
	~ADOBuildQueryDlg()
	{
	//	Worksheet wks(m_strWKSName);
	//	if ( wks.IsValid() )
	//		wks.Destroy();
	}

	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		return DoModal(hWndParent,
			DLG_HAS_APPLY /// TD 02-29-2008 QA80-11069 BLOCK_DIRTY_DOC_MORE_WORK
			);
	}
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//int nRet = ResizeDialog::Create(hParent);
		int nRet = MultiPaneDlg::Create(hParent);
		
		return nRet;
	}
	
	BOOL IsValid() 
	{
		return m_bValid;
	}
	
	string GetConnString()
	{
		return m_strConnection;	
	}
	
	string GetSQLString()	{
		return m_strSQL;	
	}
	
	
	/// AW 06/05/2006 MORE_ON_LOAD_ODQ
	bool UpdateDlgFromWks()
	{
		
		if ( !CheckSave(CHECK_BOTH) )
			return false;
		BOOL bOK = getActiveWksQuery();
		if ( bOK )
		{
			return true;
		}
		return false;
	}
	/// END MORE_ON_LOAD_ODQ


protected:
	///----------------------------------------------
	///----------------- Message Map ----------------
	///
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_READY(OnReady)
		ON_SIZE(OnDlgResize)
		ON_BUILDER_SQL_CHANGED(IDC_ACTIVEQUERYBUILDERX1, OnBulderSQLChanged)
		ON_DESTROY(OnDestroy)
		ON_CANCEL(OnCancel)
		
		//---- CPY 4/18/06 MINIZE_BOX_AND_OTHER_CLEANUP
		ON_SYSCOMMAND(OnSystemCommand)
		ON_CMD_UI_UPDATE(ID_QUERY_SAVETOACTIVESHEET, OnUiUpdateSave)	
		ON_CMD_UI_UPDATE(ID_QUERY_SAVE, OnUiUpdateSave)	
		//----
		ON_MENU_CMD(ID_QUERY_CREATE, OnFileNew)
		ON_MENU_CMD(ID_QUERY_EXIT, OnExit)
		ON_MENU_CMD(ID_QUERY_OPEN, OnFileOpen)
		ON_MENU_CMD(ID_QUERY_SAVE, OnFileSave)
		ON_MENU_CMD(ID_QUERY_SAVEAS, OnFileSaveAs)
		ON_MENU_CMD(ID_DS_NEW, OnDSNew)
		ON_MENU_CMD(ID_DS_OPEN, OnDSOpen)
		ON_MENU_CMD(ID_DS_SAVE, OnDSSave)
		ON_MENU_CMD(ID_DS_SAVEAS, OnDSSaveAs)
		ON_MENU_CMD(ID_QUERY_SAVETOACTIVESHEET, OnSaveToActiveSheet)
		ON_MENU_CMD(ID_SETTING_OPTIONS, OnQuerySetting) 
		///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		ON_MENU_CMD(ID_USE_ODBC, OnUseODBC)
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		ON_BN_CLICKED(IDC_ADO_SHOW_BOTTOM, OnShowBottomPane)
		ON_BN_CLICKED(IDC_PREVIEW_BTN, OnPreview)
		ON_BN_CLICKED(IDC_IMPORT_BTN, OnImport)
		ON_MENU_CMD_RANGE(IDC_RECENT_FILE_LIST_BEGIN, IDC_RECENT_FILE_LIST_END, OnSelMostRecentFileList)  /// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		ON_MENU_CMD_RANGE(ID_DS_FLIST_BEGIN, IDC_RECENT_FILE_LIST_BEGIN, OnSelDSMostRecentFileList)	///Jasmine 04/11/06 ADD_MRDSFLIST
		ON_BN_CLICKED(IDC_ADO_BN_SQL, OnShowSQLBox)
		ON_USER_MSG(WM_USER_SQL_TEXT_CHANGE, OnQueryTextChanged)
		ON_USER_MSG(WM_USER_SQL_CLEAR_CHANGE, OnClearQueryChanged)
		ON_USER_MSG(WM_USER_SQL_BOX_CLOSE, OnSQLBoxClose)
		ON_HELPINFO(OnHelp)

	EVENTS_END
	///----------------------------------------------
	
	///////////////////////////////////////////////////////
	/// Event Handlers
	///////////////////////////////////////////////////////
	
	//----- CPY 1/25/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL_BUT_ALLOW_SWITCH_WKS
	bool OnSystemCommand(int nCmd)
	{
		if(SC_MINIMIZE == nCmd)
		{
			if(IsRolledup())
			{
				Worksheet wks = Project.ActiveLayer();
				if(wks) // possible to switch to
					invalidateActiveWks();
			}
		}
		return MultiPaneDlg::OnSystemCommand(nCmd);
	}
	//-----

	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_ADO_DLG;
		return true;
	}
	
	BOOL OnInitDialog()  
	{
		init(); 
		//ResizeDialog::OnInitDialog(IDC_ACTIVEQUERYBUILDERX1, "Query Builder Dialog");
		
		//m_treeEditCntrl.Init(IDC_HTTP_GRID, false, true, NULL, *this);
		vector<string>  vstrTipsUpDown = {"Show Preview", "No Preview"};
		vector<string>  vstrTipsTop = {"No SQL Editor", "Show SQL Editor"};
		MultiPaneDlg::OnInitDialog(IDC_ACTIVEQUERYBUILDERX1, IDC_ADO_SHOW_BOTTOM, IDC_ADO_WKS_PREVIEW, vstrTipsUpDown, STR_QUERY_DLG_NAME, 0, NULL, false, vstrTipsTop);

		/// EJP 2007-12-07 v8.0765 FIX_QUERY_BUILDER_MENU_WHEN_CHANGE_ORIGIN_LANG
		InitToolBar(IDR_QUERY_MENU);
		SetLangMenu(IDR_QUERY_MENU);
		/// end FIX_QUERY_BUILDER_MENU_WHEN_CHANGE_ORIGIN_LANG
		
		Text = STR_QUERY_DLG_NAME;
		try 
		{
			Control QueryControl = GetItem(IDC_ACTIVEQUERYBUILDERX1);
			if(QueryControl)
			{
				m_ActiveQueryBuilderX = QueryControl.GetActiveXControl();
				//m_ActiveQueryBuilderX.LoginPrompt = FALSE;		// will change later based on how they fix the bug
				
				/// AW 11/02/07 QUERYBUILD_LOCALIZATION
				Object Localizer = m_ActiveQueryBuilderX.Localizer;
				//---- CPY 11/3/2007 LANGUAGE_CHAR_FROM_OC
				/*
				stWCBUSERINFO UserInfo;
				Localizer.CurrentLanguage = -1;  //reset
				GetUserInfo(&UserInfo);
				if ('J' == *(UserInfo.lpstrLanguageCharater) )
					Localizer.CurrentLanguage = QB_LANG_J;
				else if ('G' == *(UserInfo.lpstrLanguageCharater) )
					Localizer.CurrentLanguage = QB_LANG_G;
				else if ('C' == *(UserInfo.lpstrLanguageCharater) )
					Localizer.CurrentLanguage = QB_LANG_C; 
				*/
				/// AW 11/02/07 MORE_ON_QUERYBUILD_LOCALIZATION
				// It looks we must reset it first. I have tried to save the lang vaule,  if it is same lang then not set it, but also not work
				///Sophy 9/18/2009 RESET_CURRENT_LANGUAGE_OF_LOCALIZER_IN_QUERY_BUILDER_CAUSE_EXCEPTION
				//In recent builds, the following statement causes exception and will interrupt the initialization, so I comment out it.
				//Localizer.CurrentLanguage = -1;		
				///end RESET_CURRENT_LANGUAGE_OF_LOCALIZER_IN_QUERY_BUILDER_CAUSE_EXCEPTION
				/// END MORE_ON_QUERYBUILD_LOCALIZATION

				switch(get_current_language())
				{
				case ORESLANG_GERMAN:
					Localizer.CurrentLanguage = QB_LANG_G;
					break;
				case ORESLANG_JAPANESE:
					Localizer.CurrentLanguage = QB_LANG_J;
					break;
				case ORESLANG_CHINESE:
					Localizer.CurrentLanguage = QB_LANG_C;
					break;
				/// AW 11/02/07 MORE_ON_QUERYBUILD_LOCALIZATION
				//default:
				//	Localizer.CurrentLanguage = -1;
				//	break;
				/// END MORE_ON_QUERYBUILD_LOCALIZATION
				}
				//---- end LANGUAGE_CHAR_FROM_OC

				/// END QUERYBUILD_LOCALIZATION
				
				/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
				// m_ActiveQueryBuilderX.LoginPrompt = false  /// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
				/// END MORE_ON_LOGIN_PROMPT
			}
		}
		catch (int nError)
		{
			m_ActiveQueryBuilderX = NULL;

		}
		if ( NULL == m_ActiveQueryBuilderX )
		{
			MessageBox(GetSafeHwnd(), STR_ERR_INIT_QUERY, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			return false;
		}
		m_btnPreview=GetItem(IDC_PREVIEW_BTN);
		m_btnPreview.Enable = IsBottomPaneShown();
		m_editConnStr= GetItem(IDC_ADO_CONN_STR);
		m_btnShowSQL = GetItem(IDC_ADO_BN_SQL);
		m_btnImport = GetItem(IDC_IMPORT_BTN);
		///Jasmine 09/19/07 QA80-10385 LOCALIZATION_FOR_NEUTRAL_DIALOG
		m_btnShowSQL.Text = STR_SHOW_SQL;
		m_btnPreview.Text = _L("Preview");
		m_btnImport.Text = _L("Import");
		///End LOCALIZATION_FOR_NEUTRAL_DIALOG		
//		if ( getPreviewWks() )
//			return false;
		m_bTempWksCreated = false;
		///Jasmine 04/11/06 GET_QUERY_IN_ACTIVE_WKS
//		m_bOpenFile = false;
		getActiveWksQuery();	
		///End GET_QUERY_IN_ACTIVE_WKS
		if ( m_bReady ) 
		{
			return TRUE;  // user will create DS and query
		}
		//m_bOpenFile = false;
		/// AW 03/09/06 As need input PW, it is good not open file directly
		/*
		if ( 0 != m_strFileName.Compare(STR_NO_NAME_TITLE + STR_QUERY_FILE_EXT) )
		{
			if ( !OpenFile(m_strFileName) )
			{
				return FALSE;	
			}
		}
		*/
		
//		Connect();
		/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		m_MRFList.Init(GetSafeHwnd(), ID_QUERY_EXIT, STR_INI_SECTION_ADO_RECENT_FILE, NULL);
		/// END  ADD_RECENT_FILE_LIST_CLASS
		//---- CPY 4/28/06 MRF_ON_POPUP_MENU
		//m_MRDSFList.Init(GetSafeHwnd(), IDC_RECENT_FILE_LIST_BEGIN, STR_INI_SECTION_ADO_DS_RECENT_FILE, NULL, ID_DS_FLIST_BEGIN, ID_DS_FLIST_SEPARATOR);	///Jasmine 04/11/06 ADD_MRDSFLIST
		m_MRDSFList.Init(GetSafeHwnd(), ID_DS_SAVE, STR_INI_SECTION_ADO_DS_RECENT_FILE, NULL, ID_DS_FLIST_BEGIN, ID_DS_FLIST_SEPARATOR, 0, 8);
		//----
		return true;
	}
	
	BOOL OnReady()
	{
		UpdateDlgSize();
		UpdateDlgShow();
		//m_btnPreview.ShowWindow(IsBottomPaneShown() ? SW_NORMAL : SW_HIDE);
		SetInitReady();
		updateTopPaneControlShow();
		return true;
	}
	//---- CPY 4/18/06 MINIZE_BOX_AND_OTHER_CLEANUP
	BOOL OnUiUpdateSave(CmdUI cmd)
	{
		bool bEnable = !m_strSQL.IsEmpty();
		cmd.Enable(bEnable);
		return TRUE;
	}
	//----
	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		uint nRightIDs[]  = { 0};
		uint nBottomIDs[]  = {IDC_IMPORT_BTN, IDC_PREVIEW_BTN, IDC_ADO_BN_SQL, 0};//, IDC_ADO_SHOW_BOTTOM
		/// PREVIEW_WKS
		/*
		ResizeMoveControlsRightBottom(IDC_ACTIVEQUERYBUILDERX1, nRightIDs, nBottomIDs, cx, cy);
		RECT rr;
		int nEdge = GetControlGap();
		GetClientRect(m_SQL, rr);
		rr.right = cx - nEdge;
		rr.bottom = cy - nEdge;
		MoveControl(m_SQL, rr);
		*/
		MultiPaneDlg::OnDlgResize(nBottomIDs, cx, cy, false);
		RECT rr;
		GetClientRect(m_btnShowSQL, rr);
		int nGap = GetControlGap();
		rr.right = rr.left - nGap;
		rr.left = nGap;
		MoveControl(m_editConnStr, rr);

		updateTopPaneControlShow();

		return true;
	}
	BOOL OnShowBottomPane(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);
		m_btnPreview.Enable = IsBottomPaneShown();
		return TRUE;
	}
	void OnSQLBoxClose(DWORD wParam, DWORD lParam)
	{
		m_btnShowSQL.Text = STR_SHOW_SQL;
	}

	void OnQueryTextChanged(DWORD wParam, DWORD lParam)
	{
		OnSQLStringChanged();
	}
	void OnClearQueryChanged(DWORD wParam, DWORD lParam)
	{
		_DB_MSG("enter OnClearQueryChanged");
		m_bSQLModified = false;
		updateDialogTitle();
	}
	BOOL OnBulderSQLChanged(Control cntrl)
	{
		if ( m_bLockQuery )
		{
			return true;
		}
		_DB_MSG("Enter Querybuild Changed");  // temp testing codes
		_DB_MSG("Querybuild Changed");  // temp testing codes
		//m_strSQL = m_ActiveQueryBuilderX.FormattedSQL;
		string strSQL = m_ActiveQueryBuilderX.FormattedSQL;
		setSQLString(strSQL, false);
		m_bSQLModified = true;		
		return TRUE;
	}

	BOOL OnSQLStringChanged()//Control cntrl)
	{
		string strSQL = getSQLBoxStr();
		try
		{
			_DB_MSG("Enter Edit Changed");
			if ( ! m_bValid ) 
				return TRUE;
			//m_ActiveQueryBuilderX.Sql = m_SQL.Text;
			//if ( m_bSameSQL )
			_DB_MSG("Edit Changed");
			///Jasmine 04/14/06
			///End
			_DB_MSG("[EDIT SQL String] \n"+strSQL);  // Temp testing codes
			if ( 0 != strSQL.CompareNoCase(m_strSQL ) ) 
			{
				//m_bLockQuery = true;
				//m_ActiveQueryBuilderX.Sql = strSQL;
				setSQLString(strSQL, true, false);
				m_bSQLModified = true;
			}

		}
		catch (int eErr)
		{
			MessageBox(GetSafeHwnd(), STR_ERR_UPDATE_QUERY, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			string strSQL = m_ActiveQueryBuilderX.FormattedSQL;
			setSQLString(strSQL, false);
			return FALSE;	
		}
		return TRUE;
	}
	BOOL OnImport(Control cntrl)
	{
		Worksheet wks;
		//---- CPY 5/8/06 IMPORT_TO_LINKED_WKS_IF_PRESENT
//---CPY 5/11/06 ALWAYS_IMPORT_TO_ACTIVE_SHEET
/*
		if(isWksSaving())
		{
			Worksheet wkslinked(m_strFileName);
			if(wkslinked)
				wks = wkslinked;
		}
		else
*/
//---
			testSaveToActiveSheet(wks);
		
		if(!wks)
		//---- end IMPORT_TO_LINKED_WKS_IF_PRESENT
			wks.Create("origin");
			
	//	m_strConnection = m_ActiveQueryBuilderX.ConnectionString;   /// AW 05/05/2006  HANDLE_PASSWORD_IN_CONNECTION, should not reset it, 
		///Sophy 12/25/2009 QA80-14057-P2 FAIL_TO_SELECT_DATA_FROM_TABLE_NOT_IN_DEFAULT_DATABASE
		//string strSQL = m_ActiveQueryBuilderX.FormattedSQL;
		string strSQL = m_strSQL;
		///end FAIL_TO_SELECT_DATA_FROM_TABLE_NOT_IN_DEFAULT_DATABASE
#ifndef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__	///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		db_wks_set_query(wks, m_strConnection, strSQL);
		///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#else	
		db_wks_set_query(wks, m_strConnection, strSQL, NULL, false, &m_bUseODBC);
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		/// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
		//db_wks_import(wks);
		db_wks_import(wks, 0, 0, false, m_bLoginPrompt, GetSafeHwnd());
		/// END HANDLE_PASSWORD_IN_CONNECTION
		return true;
	}
	BOOL 	OnPreview(Control cntrl)
	{
		//Worksheet wks(m_strWKSName);
		//if ( m_wks.IsValid() )
		if(getPreviewWks())
		{
			//---- CPY 5/16/09 DB_IMPORT_PREVIEW_SHOULD_NOT_CREATE_NOTES
			LTVarTempChange junk("@IMPT", 1); // set to 1 to truncate long str, which is better for preview
			//----
			
	//		m_strConnection = m_ActiveQueryBuilderX.ConnectionString;	/// AW 05/05/2006  HANDLE_PASSWORD_IN_CONNECTION, should not reset it,
			string strSQL = m_ActiveQueryBuilderX.FormattedSQL;
			//----- CPY 4/20/06 QA70-8636 ADO_SAVED_TO_WKS
			//db_act(m_wks, m_strConnection, strSQL, DBWKS_PREVIEW);
			db_wks_set_query(m_wks, m_strConnection, strSQL);
			/// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
			//db_wks_import(m_wks, m_nPreviewLines); // conn str changed by user, we need to get it
			db_wks_import(m_wks, m_nPreviewLines, 0, false, m_bLoginPrompt); // conn str changed by user, we need to get it
			/// END HANDLE_PASSWORD_IN_CONNECTION
			
			//-----
			m_wc.Update();
			return TRUE;		
		}
		else
			out_str("failed to create preview wks");
		
		return FALSE;
	}

	BOOL OnDestroy()
	{
		//ResizeDialog::OnDestroy();
		MultiPaneDlg::OnDestroy();
		if(m_wpg)
			m_wpg.Destroy();
		/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		m_MRFList.SaveList();
		/// END ADD_RECENT_FILE_LIST_CLASS
		m_MRDSFList.SaveList();	///Jasmine 04/11/06 ADD_MRDSFLIST
		return true;
		//return //CheckSave(CHECK_QUERY);
	}

	
	BOOL OnFileNew()
	{
		if ( !CheckSave(CHECK_BOTH) )
			return FALSE;
		
		ClearSQL();
		//m_bSQLModified = false;
		//Connect();
		return true;
		
	}
	BOOL OnFileOpen()
	{
		if ( !CheckSave(CHECK_BOTH) )
			return FALSE;
		if ( !GetNewFileName(m_strFileName, STR_QUERY_FILE_DIALOG ) )
			return FALSE;
		if ( ! OpenFile(m_strFileName, TRUE) )
			return FALSE;
		
//		m_bSQLModified = false;
//		Connect();
		return true;
	}
	BOOL OnFileSave()
	{
		if ( !m_bValid )
		{
			MessageBox(GetSafeHwnd(), STR_QUESTION_NEED_QUERY);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			return FALSE;
		}
		if(isWksSaving())
			saveToWks();
		else
			SaveFile(m_strFileName, TRUE);
		
		return true;
	}
	BOOL OnFileSaveAs()
	{
		if ( !m_bValid )
		{
			MessageBox(GetSafeHwnd(), STR_QUESTION_NEED_QUERY);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			return FALSE;
		}
		if ( !GetNewFileName(m_strFileName, STR_QUERY_FILE_DIALOG, TRUE) )
			return FALSE;
		return SaveFile(m_strFileName, TRUE);
	}
	
	BOOL OnDSNew()
	{
		if ( !CheckSave(CHECK_BOTH) )
			return FALSE;
		return NewDS();
		
	} 
	BOOL OnDSOpen()
	{
		if ( !CheckSave(CHECK_BOTH) )
			return FALSE;
		if (  !GetNewFileName(m_strDSFileName, STR_DS_FILE_DIALOG) )
			return FALSE;
		OpenFile(m_strDSFileName, FALSE);
		return true;
	}
	BOOL OnDSSave()
	{
		return SaveFile(m_strFileName, FALSE);
	}
	BOOL OnDSSaveAs()
	{
		if ( !GetNewFileName(m_strDSFileName, STR_DS_FILE_DIALOG, TRUE) )
			return FALSE;
		return SaveFile(m_strDSFileName, FALSE);
	}
private:
	bool saveToWks()
	{
		Worksheet wks(m_strFileName);
		if(!wks)
			return false;
#ifndef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__	///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		if(!db_wks_set_query(wks, m_strConnection, m_strSQL, m_strDSFileName) )
		///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER	
#else
		if( !db_wks_set_query(wks, m_strConnection, m_strSQL, m_strDSFileName, false, &m_bUseODBC) )
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
		///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
		{
			ASSERT(FALSE);
			return FALSE; 
		}
		m_bSQLModified = false;
		m_bDSModified = false;
		updateDialogTitle();
		return true;
	}
	bool setFilenameToWks(const Worksheet& wks)
	{
		if(wks)
		{
			m_strFileName = wks_get_book_sheet_name(wks);
			return true;
		}
		else
			return false;
	}
	//---- CPY 5/8/06 IMPORT_TO_LINKED_WKS_IF_PRESENT
	bool testSaveToActiveSheet(Worksheet& wks)
	{
		//---- CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
		//Worksheet wksTemp = Project.ActiveLayer();
		Worksheet wksTemp = getActiveWks();
		//----
		if(wksTemp)
		{
			if(setFilenameToWks(wksTemp))
			{
				saveToWks();
				wks = wksTemp;
				return true;
			}
		}
		return false;
	}
	//----
		
		
protected:
	BOOL OnSaveToActiveSheet()
	{
		Worksheet wks;
		/*= Project.ActiveLayer();
		if(setFilenameToWks(wks))
			saveToWks();*/
		testSaveToActiveSheet(wks);
		return TRUE;
	}
	
	BOOL	OnExit()
	{
		PostMessage(WM_CLOSE); 

		return TRUE;
		
	}
	BOOL OnQuerySetting()
	{
		try
		{
			m_ActiveQueryBuilderX.EditProperties();
		}
		catch (int eErr)
		{
			MessageBox(GetSafeHwnd(), STR_ERR_FAIL_SET_OPTIONS, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
		} 
		return TRUE;
		
	}
	///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
	BOOL	OnUseODBC()
	{
		BOOL bNewStatus = !m_bUseODBC;
		return SetUseODBC(bNewStatus);
	}
	
	BOOL	SetUseODBC(BOOL bUseODBC)
	{
		//update status
		m_bUseODBC = bUseODBC && _is_datasource_allow_odbc_option(m_strConnection);
		
		//update GUI
		HWND 	hWnd = GetSafeHwnd();
		HMENU 	hMenu = GetMenu(hWnd);
		Menu	mn(hMenu);
		
		string	strItemVal;
		mn.GetMenuString(ID_USE_ODBC, strItemVal, MF_STRING);
		
		DWORD dwFlag = m_bUseODBC ? MF_CHECKED : MF_UNCHECKED;
		dwFlag |= MF_BYCOMMAND;
		dwFlag |= _is_datasource_allow_odbc_option(m_strConnection) ? 0 : MF_GRAYED;	///Sophy 12/31/2009 MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER
		mn.ModifyMenu(ID_USE_ODBC, dwFlag, ID_USE_ODBC, strItemVal);
		return TRUE;
	}
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
	///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
	///Jasmine 04/11/06 ADD_MRDSFLIST
	BOOL 	OnSelDSMostRecentFileList(int nID)
	{
		_DB_MSG("ok");
		return selMostRecentFileList(&m_MRDSFList, nID);
	}
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	BOOL 	OnSelMostRecentFileList(int nID)
	{
		return selMostRecentFileList(&m_MRFList, nID);
	}
	BOOL OnShowSQLBox(Control ctrl);

private:
	bool selMostRecentFileList(MRFList* pList, int nID)
	{
		if ( !CheckSave(CHECK_BOTH) )	///Jasmine 04/08/06 check change when openfile in MostRecentFileList
			return FALSE;
		string strFileName = pList->GetFromID(nID);//m_MRFList.GetFromID(nID);
		BOOL bQuery = false;
		string strTemp = strFileName.Right(4);
		strTemp.MakeLower();
		if ( strTemp.CompareNoCase(STR_QUERY_FILE_EXT) == 0 )
			bQuery = true;
		return OpenFile(strFileName, bQuery);
	}
	///End ADD_MRDSFLIST

	
protected:
	BOOL OpenFile(LPCSTR lpcszFileName, BOOL bQuery = TRUE)
	{
		if ( bQuery )
		{
			///Sophy 8/3/2009 QA80-14057 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifndef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			if (! db_load_query(m_strConnection, m_strSQL, lpcszFileName, &m_strDSFileName) )
#else
			string strQueryMode = "";
			if ( !db_load_query(m_strConnection, m_strSQL, lpcszFileName, &m_strDSFileName, NULL, &strQueryMode) )
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			{
				string strTemp;
				strTemp.Format("failed to open %s !", lpcszFileName);
				MessageBox(GetSafeHwnd(), strTemp);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
				return FALSE;
			}
			m_strFileName = lpcszFileName;
			m_bSQLModified = false;
			m_bDSModified = false;
//			m_bOpenFile = true;
			
			if(Connect())
			{
				m_MRFList.AddUpdateRecentFileList(lpcszFileName);
				_DB_MSG("After Open File");
				PostMessage(WM_USER_SQL_CLEAR_CHANGE);
				///Sophy 8/3/2009 QA80-14057 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
				m_bUseODBC = strQueryMode.CompareNoCase(STR_QUERY_MODE_ODBC) == 0 ? TRUE : FALSE;
				SetUseODBC(m_bUseODBC);
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
				///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
			}
		}
		else 
		{
			string strConn;
			if(!db_load_data_source(lpcszFileName, strConn, &m_strDSFileName))
			{
				string strTemp;
				strTemp.Format("failed to open %s !", lpcszFileName);
				MessageBox(GetSafeHwnd(), strTemp);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
				return FALSE;
			}
			if(onNewDS(strConn, lpcszFileName))
			{
				m_MRDSFList.AddUpdateRecentFileList(lpcszFileName);	///Jasmine 04/11/06 ADD_MRDSFLIST
			}
		}
		return TRUE;
	}
	string ReadDSFile(LPCSTR lpcszFileName)
	{
		string strContents="";
		stdioFile ff;
		bool bRet = ff.Open(lpcszFileName, file::modeRead);
		if(bRet)
		{
			ff.ReadString(strContents);
			ff.Close();
		}
		return strContents;
	}
	BOOL SaveFile(LPCSTR lpcszFileName, BOOL bQuery = TRUE)
	{
		if ( strlen(lpcszFileName) == 0 )
			return false;
		string strTemp, strContents;
		if ( bQuery )
		{
			///Sophy 8/3/2009 QA80-14057 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifndef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			if ( ! db_save_query(lpcszFileName, m_strConnection, m_strSQL, m_strDSFileName) )
				return FALSE;
#else
			string strQueryMode = m_bUseODBC ? STR_QUERY_MODE_ODBC : STR_QUERY_MODE_ADO;
			if ( ! db_save_query(lpcszFileName, m_strConnection, m_strSQL, m_strDSFileName, strQueryMode) )
				return FALSE;
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
			m_bSQLModified = false;
			/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
			m_MRFList.AddUpdateRecentFileList(lpcszFileName);
			/// END ADD_RECENT_FILE_LIST_CLASS
		}
		else
		{
			if ( 0 > okutil_write_file_section(lpcszFileName, STR_DATA_SOURCE, m_strConnection, NULL) )
				return FALSE;
			m_bDSModified = false;
			m_MRDSFList.AddUpdateRecentFileList(lpcszFileName);	///Jasmine 04/11/06 ADD_MRDSFLIST
		}
		updateDialogTitle();
		return TRUE;
	}
	BOOL HandleFileError(LPCSTR lpcszFileName, LPCSTR lpcszSectionName, int nErr)
	{
		string strErr;
		switch (nErr)
		{
			case ERR_CODE_FAIL_OPEN_FILE:
				strErr.Format(STR_ERR_FAIL_OPEN_FILE, lpcszFileName);
				break;
			case ERR_CODE_FAIL_READ_SECTION:
				strErr.Format(STR_ERR_FAIL_READ_SECTION, lpcszSectionName, lpcszFileName);
				break;
			case ERR_CODE_FAIL_SAVE_FILE:
				strErr.Format(STR_ERR_FAIL_SAVE_FILE, lpcszFileName);
				break;
			default:
				ASSERT(FALSE);
		}
		MessageBox(GetSafeHwnd(), strErr, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
		return FALSE;
	}
	BOOL Connect(BOOL bDSUpdated = FALSE)
	{
		//--- CPY 2-28-2006
		m_bValid = FALSE;
		if(m_strConnection.IsEmpty())
		{
			updateDialogTitle();
			return false;
		}
		//---
		if(!bDSUpdated)
		{
			_DB_MSG("before set connect");
			bool bRet = setConnString( m_strConnection );
			_DB_MSG("after set connect");

			if ( m_strConnection.IsEmpty() || !bRet )
			{
				//m_ActiveQueryBuilderX.EditConnectionString();	
				m_strConnection = m_ActiveQueryBuilderX.ConnectionString;
				return false;
			}
		}
		try
		{
			//m_ActiveQueryBuilderX.Sql = m_strSQL;
			setSQLString(m_strSQL);
			_DB_MSG("before connect");
			_DB_MSG(m_strSQL);
			m_bLockQuery = true;
			/// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
			//BOOL bOldPrompt = m_ActiveQueryBuilderX.LoginPrompt;
			//m_ActiveQueryBuilderX.LoginPrompt = isDSPasswordSaved()? false:true;
			/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
			// m_bLoginPrompt = isDSPasswordSaved()? false:true;
			/// END AW 02/04/08 MORE_ON_LOGIN_PROMPT
			if ( m_bLoginPrompt )
			{
				string& strConn = m_strConnection;
				string strUser, strDS;
				/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
				//bool bSavePwdBackToWks = DB_GetPassword(GetSafeHwnd(), strDS, strUser, strConn, false); 
				bool bSavePwdBackToWks = DB_GetPassword(GetSafeHwnd(), strDS, strUser, strConn, _L("Save Passwrod?"), false); 
				/// END MORE_ON_LOGIN_PROMPT
				if ( bSavePwdBackToWks )
				{
					m_strConnection = strConn;
					m_ActiveQueryBuilderX.ConnectionString = m_strConnection;
					/// AW 02/04/08 MORE_ON_LOGIN_PROMPT
					m_ActiveQueryBuilderX.LoginPrompt = false;
					m_bLoginPrompt = false;
					/// END MORE_ON_LOGIN_PROMPT
				}
			}
			/// END HANDLE_PASSWORD_IN_CONNECTION
			m_ActiveQueryBuilderX.Connect();
			m_ActiveQueryBuilderX.RefreshMetadata();   // temp codes as new dll did not fix the "open second DS" bug totally
			//m_ActiveQueryBuilderX.LoginPrompt = bOldPrompt;  /// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
			m_bLockQuery = false;
			_DB_MSG("after connect");
//			string strNewConnect = m_ActiveQueryBuilderX.ConnectionString;
//			m_strConnection = strNewConnect;
			
			m_bValid = m_ActiveQueryBuilderX.Connected ==  0? FALSE : TRUE;  
		}
		catch (int nError)
		{
			/// Wait for more Error handle here
			MessageBox(GetSafeHwnd(), STR_ERR_QUERY_BUILD, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
		}
		updateDialogTitle();
		return m_bValid;
	}
	BOOL GetNewFileName(string& strFileName, LPCSTR lpcszFileType, BOOL bSave = FALSE)
	{
		string strUserPath = GetAppPath();
		string strTempFileName;
		if ( bSave )
			strTempFileName = GetSaveAsBox( lpcszFileType, strUserPath, strFileName );
		else
			strTempFileName = GetOpenBox( lpcszFileType, strUserPath, strFileName );
		if ( !strTempFileName.IsEmpty() )
		{
			strFileName = strTempFileName;
			return TRUE;
		}
		return FALSE;;
	}
	BOOL CheckSave(int nOpetion)
	{
		if ( nOpetion & CHECK_DS )
		{
			//string strNewConnect = ReadDSFile(m_strDSFileName);	
			//string strNewConnect = m_ActiveQueryBuilderX.ConnectionString;
			//if ( 0 != strNewConnect.Compare(m_strConnection) )  
			if ( m_bDSModified && m_strDSFileName != STR_NO_DS)
			{
				string strMsg;
				strMsg.Format(STR_MSG_SAVE_CHANGED_IN_FILE, m_strDSFileName);
				//m_strConnection = strNewConnect;
				if ( IDYES == MessageBox(GetSafeHwnd(), strMsg, STR_WARNING, MB_YESNO) )///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
				{
					if ( !GetNewFileName(m_strDSFileName, STR_DS_FILE_DIALOG, TRUE) )
						return TRUE;
					if ( !SaveFile(m_strDSFileName, FALSE) )
						return FALSE;
				}
			}
		}
		if ( nOpetion & CHECK_QUERY )
		{
			if ( m_bSQLModified )
			//string strNewSQL = m_ActiveQueryBuilderX.FormattedSQL;	
			//if ( 0 != strNewSQL.Compare(m_strSQL) )
			{
				string strMsg;
				strMsg.Format(STR_MSG_SAVE_CHANGED_IN_FILE, m_strFileName);
				m_strSQL = m_ActiveQueryBuilderX.FormattedSQL;
				if ( IDYES == MessageBox(GetSafeHwnd(), strMsg, STR_WARNING, MB_YESNO) )///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
				{
					if ( !GetNewFileName(m_strFileName, STR_QUERY_FILE_DIALOG, TRUE) )
						return TRUE;
					if ( !SaveFile(m_strFileName) )
						return FALSE;
				}
			}
		}
		return TRUE;
		
	}
	BOOL NewDS()
	{
		//m_strConnection = "";
		//m_strSQL = "";
		/// AW 04/27/06 SET_DEFAULT_PROVIDER
		//return onNewDS("");  					
		return onNewDS(m_strDefaultProvider);	
		/// END SET_DEFAULT_PROVIDER
	
	}
	BOOL ClearSQL(bool bCheckConnStr = true)
	{
		m_strFileName = STR_NO_NAME_TITLE + STR_QUERY_FILE_EXT;
		if (bCheckConnStr && m_strConnection.IsEmpty() )
		{
			MessageBox(GetSafeHwnd(), STR_QUESTION_NEED_DS);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			return FALSE;
		}
		
		//return EditDS();
		m_bSQLModified = false;
	//		m_bOpenFile = TRUE;
		setSQLString("");
		//m_SQL.Text = m_strSQL;	///Jasmine 04/17/06 HIDE_IDC_EDIT_SQL
		return TRUE;
	}
private:
	bool isDSPasswordSaved()
	{
		return db_is_connection_str_has_password(m_strConnection);
	}
	bool hasFileExt(LPCSTR lpcszStr, string* pStrExt = NULL)
	{
		char szFile[MAX_PATH];
		if(lstrlen(lpcszStr) >= MAX_PATH)
			return false;
		lstrcpy(szFile, lpcszStr);
		char szTemp[MAXLINE];
		///------ Folger 05/11/09 QA80-13571 CHECK_ADD_FILE_EXT_SHOULD_RETURN_PROPER_ERROR
		//if(!check_add_file_ext(szFile, NULL, szTemp)) // has Ext
		if( CHECKADDFILEEXT_HAS_EXTENSION == check_add_file_ext(szFile, NULL, szTemp) ) // has Ext
		///------ End CHECK_ADD_FILE_EXT_SHOULD_RETURN_PROPER_ERROR
		{
			if(pStrExt) *pStrExt = szTemp;
			return true;
		}
		return false;
	}
	bool isWksSaving(LPCSTR lpcszFilename = NULL)
	{
		string str;
		if(lpcszFilename)
			str = lpcszFilename;
		else
			str = m_strFileName;
		
		int nLen = str.GetLength();
		if(nLen > 1 && m_strFileName[0]=='[' && !hasFileExt(m_strFileName))
			return true;
		
		return false;
	}
	void updateDialogTitle()
	{
		string strDlgTitle, strDSFile, strFile;
		strDSFile = GetFileName(m_strDSFileName);
		if(m_bDSModified)
			strDSFile +="*";
			
		strFile = GetFileName(m_strFileName);
		if(m_bSQLModified)
			strFile+= "*";
		if(strDSFile.IsEmpty())
			strDlgTitle = strFile;
		else			
			strDlgTitle = strDSFile +" - "+ strFile;//m_strDSFileName +" - "+ m_strFileName;//m_strFileName;	///jasmine 04/08/06 show both ods and odq file name in title
		string strDlgName = STR_QUERY_DLG_NAME; 
		m_wndDlg.Text = strDlgName + " - " + strDlgTitle;
		
		/// AW 06/18/08 QA80-11727 HIDE_PW_IN_ADO
		//m_editConnStr.Text = m_strConnection;
		m_editConnStr.Text = hidePW(m_strConnection);
		/// END  HIDE_PW_IN_ADO
		
		bool bEnable = !m_strSQL.IsEmpty();
		m_btnImport.Enable = bEnable;
	}
	/// AW 06/18/08 QA80-11727 HIDE_PW_IN_ADO
	string hidePW(string strConnection) 
	{
	/// EJP 2009-03-27 QA80-11727 MORE_HIDE_PW_IN_QUERYBUILDER_DLG
	///	int nPos = strConnection.Find(STR_PASSWORD);
		hideValueByKey(strConnection, STR_PASSWORD);
		hideValueByKey(strConnection, STR_PWD);
		return strConnection;
	}
	void hideValueByKey(string& strConnection, LPCSTR pcszKey)
	{
		int nPos = strConnection.Find(pcszKey);
	/// end MORE_HIDE_PW_IN_QUERYBUILDER_DLG

		/// EJP 2008-09-19 v8.0944 QA80-11727 HIDE_PW_IN_QUERYBUILDER_DLG
		///	int nPosEnd;
		///	if ( nPos > 0 )
		///	{
		///		nPos += strlen(STR_PASSWORD);
		///		nPosEnd = strConnection.Find(';', nPos);
		///		strConnection = strConnection.Left(nPos) + "***" + strConnection.Right(strConnection.GetLength()-nPosEnd);
		///	}
		if( nPos >= 0 )
		{
			/// EJP 2009-03-27 QA80-11727 MORE_HIDE_PW_IN_QUERYBUILDER_DLG
			///nPos += strlen(STR_PASSWORD); // move nPos to first char after '='
			nPos += strlen(pcszKey); // move nPos to first char after '='
			/// end MORE_HIDE_PW_IN_QUERYBUILDER_DLG

			int nPosEnd = strConnection.Find(';', nPos); // find next ';'
			if( nPosEnd == -1 ) // if password is at end of connection str
				nPosEnd = strConnection.GetLength();
			strConnection.Delete(nPos, nPosEnd - nPos);
			strConnection.Insert(nPos, "***");
		}
		/// end HIDE_PW_IN_QUERYBUILDER_DLG

		/// EJP 2009-03-27 QA80-11727 MORE_HIDE_PW_IN_QUERYBUILDER_DLG
		///return strConnection;
		/// end MORE_HIDE_PW_IN_QUERYBUILDER_DLG
	}
	/// END HIDE_PW_IN_ADO
	BOOL onNewDS(LPCSTR lpcszConn, LPCSTR lpcszDSFilename=NULL)
	{
		BOOL bRet = TRUE;
		string strNewConnection = lpcszConn;
		try
		{
			///Sophy 3/3/2010 QA81-14057-P5 LOAD_RECENT_ODS_FILE_SHOULD_NOT_NEED_TO_EDIT_CONNSTR
			//bRet = setConnString( lpcszConn, true );
			string strODSFile(lpcszDSFilename);
			bool bOpenDataLink = !strODSFile.IsFile();
			bRet = setConnString(lpcszConn, bOpenDataLink);
			///end LOAD_RECENT_ODS_FILE_SHOULD_NOT_NEED_TO_EDIT_CONNSTR
			///end 
		}
		catch (int eErr)
		{
			MessageBox(GetSafeHwnd(), STR_ERR_INVALID_CONNECT_STR, STR_ERR);///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			bRet = setConnString( "" );
			strNewConnection = m_ActiveQueryBuilderX.ConnectionString;
		} 
		if ( bRet )
		{
			string strTemp = m_ActiveQueryBuilderX.ConnectionString;
			//ClearSQL(false);    /// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION  first need set m_strConnection
			m_strConnection = strNewConnection;
			ClearSQL(false);    /// AW 05/05/2006 HANDLE_PASSWORD_IN_CONNECTION
	//			m_ActiveQueryBuilderX.LoginPrompt = FALSE;
			strNewConnection = m_ActiveQueryBuilderX.ConnectionString;
			//setSQLString(m_strSQL, false);
	//			m_ActiveQueryBuilderX.LoginPrompt = TRUE;
		}
		else
		{
			///Sophy 3/3/2010 QA81-14057-P5 LOAD_RECENT_ODS_FILE_SHOULD_NOT_NEED_TO_EDIT_CONNSTR
			try
			{
				setConnString(m_strConnection);
			}
			catch(int nErr)
			{
				error_report("Exception when setConnString");
			}
			///end LOAD_RECENT_ODS_FILE_SHOULD_NOT_NEED_TO_EDIT_CONNSTR
			return true;  // nothing changed
		}
		m_bDSModified = false;
		if(lpcszDSFilename)
			m_strDSFileName = lpcszDSFilename;
		else
			///Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE 
			//m_strDSFileName = _L("Untitled.ods");
			m_strDSFileName = "Untitled.ods";
			///End SET_NO_NEED_TO_LOCALIZE
		if ( strNewConnection.Compare(m_strConnection) != 0 )
		{
			m_bDSModified = true;
			m_strConnection = strNewConnection;
		}
		//m_strFileName = STR_NO_NAME_TITLE + STR_QUERY_FILE_EXT;
		//m_bSQLModified = false;	
		///Sophy 12/31/2009 MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER
		SetUseODBC(m_bUseODBC);
		///end MORE_WORK_ON_ODBC_OPTION_IN_QUERY_BUILDER
		return Connect(TRUE);
	}
	
private:
	bool askCanExit()
	{
		return CheckSave(CHECK_BOTH);
	}
	void updateSQLBox(LPCSTR lpcszSQL = NULL);
	string getSQLBoxStr();

protected:
	BOOL	OnCancel()
	{
		return askCanExit();
	}
};



#endif  // _ORIGIN_ADO_H
